import numpy as np
import time
import Kiban
import PlayerRandom
import Const
import Qtable
import PlayerAI
import PlayerHuman


"""メインクラス
"""
class Main:

    def __init__(self):
        self.kiban = Kiban.Kiban(Const.BANSU)   #棋盤クラス
        self.qtable = Qtable.Qtable()       #Q値クラス
        self.playerrandom = PlayerRandom.PlayerRandom() #ランダムに打つコンピュータプレイヤークラス
        self.playerai = PlayerAI.PlayerAI() #学習するAIプレイヤークラス
        self.playerhuman = PlayerHuman.PlayerHuman()    #人用クラス
                
        win =  [0] * 3
        ran =100000    #試行回数
        start_time = time.time()        
        player = [self.playerrandom,self.playerai] #対戦プレイヤー設定 [先攻、後攻]

        for i in range(ran):    #試行ループ
            greedy = Const.GREEDY * (ran-i) / ran   #AIのランダム手数の確立を徐々に下げる  
            ret = self.play(player,greedy)   #対戦 play[先手,後手]
            self.kiban.clear(Const.BANSU)

            if player[0].whois() == Const.HUMAN or player[1].whois() == Const.HUMAN:
                if ret == Const.EXIT:   #人の指示により強制終了
                    break
                print(Const.MSG[ret])   #人対戦の時の結果を表示
            win[ret] += 1
            if (i+1) % 10000 == 0:
                comp = str((win[2] / (i+1))*100)
                print(str(i+1)+"回:先攻勝:"+str(win[1])+" 後攻勝:"+str(win[2])+" 引分け:"+str(win[0])+" 後攻勝率:" +comp)

        comp = str((win[2] / ran)*100)
        print ('時間:'+format(time.time() - start_time))
        print("先攻勝:"+str(win[1])+" 後攻勝:"+str(win[2])+" 引分け:"+str(win[0])+" 後攻勝率:" +comp)
        
        """試行後に人対戦を行いたい時に下記コメントを削除
        """
        """        
        while True:
            ret = self.play([self.playerhuman,self.playerai],0.2)
            if ret == Const.EXIT:
                break        
            print(Const.MSG[ret])   #人対戦の時の結果を表示
            self.kiban.clear(Const.BANSU)
        """
    """ゲームメイン処理
    """
    def play(self,players,greedy):  #ゲーム
        state = True    #先攻：Ture、後攻：False
        count = 0       #打ち手回数
        isExit = False
        exit_status = 0
        key =  [0] * 2  #状態情報、[0]：先攻　[1]:後攻
        xy =  np.zeros((2,2),dtype=int) #打ったX,Y座標用。これから状態のQ値を求める
        win = 0

        while True: #ゲーム終了までループ
            for idx,player in enumerate(players):   #先攻、後攻交互にループ
                key[idx] = self.kiban.kibanToString()   #棋盤情報から状態情報へ変換し格納
                ret = player.play(self.kiban,self.qtable,greedy)#手を考える                

                if not ret: #人用　強制終了したいなら
                    exit_status = Const.EXIT
                    isExit = True
                    break

                xy[idx] = ret
                kigou = Const.BATU if state else Const.MARU     #先攻、後攻用のマーク(×、○)を取得

                self.kiban.setKiban(xy[idx][0],xy[idx][1],kigou)    #棋盤に手を打つ

                if players[0].whois() == Const.HUMAN or players[1].whois() == Const.HUMAN:  #人対戦なら棋盤表示
                    self.kiban.disp()

                if player.whois() != Const.AI:  #AIでないなら手を打った後の状態情報を格納する
                    key[idx] = self.kiban.kibanToString()

                exit_status = self.kiban.checkFinal(xy[idx][0],xy[idx][1]) #勝敗判定

                if  exit_status != Const.KUHAKU:    #勝敗が決まった？
                    if player.whois() == Const.AI:
                        win = Const.WIN_VALUE   #勝ち報酬
                    else:
                        win = Const.LOSS_VALUE  #負けペナルティ
                    isExit = True               

                state = not state #手番を変更
                count += 1  #手数をカウントアップ

                if count >= Const.BANSU * Const.BANSU: #打つ手が無くなった？
                    win = Const.DRAW_VALUE
                    isExit = True

                if isExit == True:  #終了
                    if player.whois() == Const.AI:  #勝負が決まった。AIが打った　Q値更新
                        self.qtable.cal(key[idx],0,xy[idx][0],xy[idx][1],win)
                    else:                           #勝負が決まった。AI以外が打った　Q値更新
                        self.qtable.cal(key[abs(idx-1)],0,xy[abs(idx-1)][0],xy[abs(idx-1)][1],win)
                    break

                if player.whois() != Const.AI and count != 1: #未決着 　AIや一手目(次の手がない)以外ならQ値更新
                    self.qtable.cal(key[abs(idx-1)],key[idx],xy[abs(idx-1)][0],xy[abs(idx-1)][1],win)
                
            if isExit==True: 
                break

        return exit_status

Main()
